<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/


class XenCentral_AdServer_ControllerPublic_Account extends XenForo_ControllerPublic_Account
{
    protected function _preDispatch($action)
    {
        parent::_preDispatch($action);
        if (!XenCentral_AdServer_Permissions::canUse()) {
            throw $this->getNoPermissionResponseException();
        }
    }

    public function actionTransactions()
    {
        $transactions = $this->_getPurchaseLogModel()->getUserTransactions(XenForo_Visitor::getUserId());
        $creditTransactions = $this->_getCreditLogModel()->getUserTransactions(array(
            'user_id'=> XenForo_Visitor::getUserId()
        ));

        return $this->_getWrapper(
            'ads', 'transactions',
            $this->responseView('XenCentral_AdServer_ViewPublic_Transactions', 'xcas_transaction_list', array(
                'transactions' => $transactions,
                'creditTransactions' => $creditTransactions,
                'breadCrumbs' => $this->_getBreadCrumbs(new XenForo_Phrase('xcas_transactions'))
            ))
        );
    }

    public function actionCredits()
    {
        return $this->responseRedirect(
            XenForo_ControllerResponse_Redirect::SUCCESS,
            XenForo_Link::buildPublicLink('ads/zone/custom')
        );
    }

    public function actionAdvertiserConfiguration()
    {
        if ($this->isConfirmedPost()) {
            $user = $this->_getUserModel()->getAdServerUserInfo(XenForo_Visitor::getUserId());
            $excluded_campaign_domains = $this->_input->filterSingle('excluded_campaign_domains', XenForo_Input::ARRAY_SIMPLE);
            $excluded_campaign_domains = array_map('trim', $excluded_campaign_domains);
            $excluded_campaign_domains = array_diff($excluded_campaign_domains, array(''));
            $user['excluded_campaign_domains'] = $excluded_campaign_domains;
            $this->_getUserModel()->updateAdServerUserInfo($user);
        }

        return $this->responseRedirect(
            XenForo_ControllerResponse_Redirect::SUCCESS,
            XenForo_Link::buildPublicLink('ads/zone/custom')
        );

        $user = $this->_getUserModel()->getAdServerUserInfo(XenForo_Visitor::getUserId());
        $user['excluded_campaign_domains'][] = '';

        return $this->_getWrapper(
            'ads', 'advertiser-configuration',
            $this->responseView('XenCentral_AdServer_ViewPublic_AdvertiserConfiguration', 'xcas_advertiser_configuration', array(
                'user' => $user,
                'breadCrumbs' => $this->_getBreadCrumbs(new XenForo_Phrase('xcas_campaign_configuration'))
            ))
        );
    }

    public function responseView($viewName = '', $templateName = '', array $params = array(), array $containerParams = array())
    {
        if (isset($params['breadCrumbs']) AND empty($params['title'])) {
            $lastBreadCrumb = end($params['breadCrumbs']);
            $params['title'] = $lastBreadCrumb['value'];
        }
        return parent::responseView($viewName, $templateName, $params, $containerParams);
    }

    /**
     * @param XenForo_Phrase $current
     * @return array
     */
    protected function _getBreadCrumbs($current = null)
    {
        $breadCrumbs = array(
            'account' => array(
                'href' => XenForo_Link::buildPublicLink('account'),
                'value' => new XenForo_Phrase('your_account')
            ),
            'home' => array(
                'href' => XenForo_Link::buildPublicLink('full:ads'),
                'value' => new XenForo_Phrase('xcas_my_ads')
            )
        );

        if ($current) {
            $requestPaths = XenForo_Application::get('requestPaths');
            $breadCrumbs['current'] = array(
                'href' => $requestPaths['fullUri'],
                'value' => $current
            );
        }

        return $breadCrumbs;
    }

    protected function _getIndexWrapper($controllerResponse, $selectedGroup='ads', $selectedLink='manage')
    {
        if ($controllerResponse instanceof XenForo_ControllerResponse_View) {
            return $this->_getWrapper($selectedGroup, $selectedLink, $controllerResponse);
        }
        return $controllerResponse;
    }

    /**
     * @return XenCentral_AdServer_Model_Zone
     */
    protected function _getZoneModel()
    {
        return $this->getModelFromCache('XenCentral_AdServer_Model_Zone');
    }

    /**
     * @return XenCentral_AdServer_Model_Banner
     */
    protected function _getBannerModel()
    {
        return $this->getModelFromCache('XenCentral_AdServer_Model_Banner');
    }

    /**
     * @return XenCentral_AdServer_Model_PurchaseLog
     */
    protected function _getPurchaseLogModel()
    {
        return $this->getModelFromCache('XenCentral_AdServer_Model_PurchaseLog');
    }

    /**
     * @return XenCentral_AdServer_Model_CreditLog
     */
    protected function _getCreditLogModel()
    {
        return $this->getModelFromCache('XenCentral_AdServer_Model_CreditLog');
    }

    /**
     * @return XenCentral_AdServer_Model_XenForo_User
     */
    protected function _getUserModel()
    {
        return $this->getModelFromCache('XenForo_Model_User');
    }

}